/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.client.gui.controls;

import net.minecraft.util.ResourceLocation;
import net.montoyo.wd.client.gui.controls.BasicControl;
import net.montoyo.wd.client.gui.loading.JsonOWrapper;
import org.lwjgl.opengl.GL11;

public class Icon
extends BasicControl {
    protected int width;
    protected int height;
    protected double u1;
    protected double v1;
    protected double u2;
    protected double v2;
    protected ResourceLocation texture;

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void load(JsonOWrapper json) {
        super.load(json);
        this.width = json.getInt("width", 16);
        this.height = json.getInt("height", 16);
        this.u1 = json.getDouble("u1", 0.0);
        this.v1 = json.getDouble("v1", 0.0);
        this.u2 = json.getDouble("u2", 1.0);
        this.v2 = json.getDouble("v2", 1.0);
        this.texture = new ResourceLocation(json.getString("resourceLocation", ""));
    }

    @Override
    public void draw(int mouseX, int mouseY, float ptt) {
        if (this.texture != null) {
            GL11.glEnable((int)3553);
            this.bindTexture(this.texture);
            Icon.blend(true);
            this.fillTexturedRect(this.x, this.y, this.width, this.height, this.u1, this.v1, this.u2, this.v2);
            Icon.blend(false);
            this.bindTexture(null);
        }
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setTextureCoordinates(double u1, double v1, double u2, double v2) {
        this.u1 = u1;
        this.v1 = v1;
        this.u2 = u2;
        this.v2 = v2;
    }

    public void setTexture(ResourceLocation texture) {
        this.texture = texture;
    }

    public double getU1() {
        return this.u1;
    }

    public double getV1() {
        return this.v1;
    }

    public double getU2() {
        return this.u2;
    }

    public double getV2() {
        return this.v2;
    }
}

